VERSION 5.00
Begin VB.Form frmOfferProdType 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "#Select product type"
   ClientHeight    =   3885
   ClientLeft      =   -15
   ClientTop       =   375
   ClientWidth     =   5445
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3885
   ScaleWidth      =   5445
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Tag             =   "frm_OfferProdType"
   Visible         =   0   'False
   Begin VB.Frame fra_ProdSpecType 
      Height          =   3180
      Left            =   90
      TabIndex        =   1
      Tag             =   "fra_ProdSpecType"
      Top             =   -15
      Width           =   5310
      Begin VB.OptionButton opt_ProdType 
         Caption         =   "#Service item"
         Height          =   390
         Index           =   7
         Left            =   270
         TabIndex        =   9
         Tag             =   "opt_TypeServiceItem"
         Top             =   1815
         Width           =   4410
      End
      Begin VB.OptionButton opt_ProdType 
         Caption         =   "#Manual Offer Line"
         Height          =   390
         Index           =   6
         Left            =   270
         TabIndex        =   8
         Tag             =   "opt_TypeManual"
         Top             =   1410
         Width           =   4410
      End
      Begin VB.OptionButton opt_ProdType 
         Caption         =   "#Other Vendor Products (NOT IMPLEMENTED)"
         Height          =   195
         Index           =   5
         Left            =   165
         TabIndex        =   7
         Tag             =   "opt_TypeOtherVendor"
         Top             =   2160
         Visible         =   0   'False
         Width           =   4410
      End
      Begin VB.OptionButton opt_ProdType 
         Caption         =   "#Suspension System"
         Height          =   390
         Index           =   4
         Left            =   270
         TabIndex        =   6
         Tag             =   "opt_TypeSubconstruction"
         Top             =   1005
         Width           =   4410
      End
      Begin VB.OptionButton opt_ProdType 
         Caption         =   "#Wood Products (NOT IMPLEMENTED)"
         Height          =   195
         Index           =   3
         Left            =   210
         TabIndex        =   5
         Tag             =   "opt_TypeWood"
         Top             =   2790
         Visible         =   0   'False
         Width           =   4410
      End
      Begin VB.OptionButton opt_ProdType 
         Caption         =   "#Engineered Metal Products (NOT IMPLEMENTED)"
         Height          =   195
         Index           =   2
         Left            =   225
         TabIndex        =   4
         Tag             =   "opt_TypeEngineeredMetal"
         Top             =   2460
         Visible         =   0   'False
         Width           =   4410
      End
      Begin VB.OptionButton opt_ProdType 
         Caption         =   "#Non Metal SKU Products"
         Height          =   390
         Index           =   0
         Left            =   270
         TabIndex        =   3
         Tag             =   "opt_TypeNonMetalSKU"
         Top             =   195
         Width           =   4410
      End
      Begin VB.OptionButton opt_ProdType 
         Caption         =   "#Metal Products"
         Height          =   390
         Index           =   1
         Left            =   270
         TabIndex        =   2
         Tag             =   "opt_TypeMetal"
         Top             =   600
         Width           =   4410
      End
   End
   Begin VB.CommandButton btn_Quit 
      Height          =   612
      Left            =   4725
      Style           =   1  'Graphical
      TabIndex        =   0
      Tag             =   "btn_Quit"
      Top             =   3225
      Width           =   612
   End
End
Attribute VB_Name = "frmOfferProdType"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "frmOfferProdType"

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Public Result As Boolean

#If LIVE = 1 Then
  Private mo_Db As Object
  Private mo_FSO As Object
#Else
  Private mo_Db As ARMSYSCOMLib.ArmDb
  Private mo_FSO As FileSystemObject
#End If

Private ml_U_Code As Long
Private ms_Language_Code As String
Private mb_InternalInit As Boolean
Private mc_ScreenLabels As Long
Private mo_Tools As DPC_Tools
Private me_OfferStatus As eOfferStatus

Property Let OfferStatus(le_Value As eOfferStatus)
  me_OfferStatus = le_Value
End Property

Public Property Let U_Code(ByVal al_U_Code As Long)
    ml_U_Code = al_U_Code
End Property

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler

Dim lc_Labels As Long
  
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  Call mo_Tools.Load_A_ComControls(Me.Controls, mo_Db, ms_Language_Code)
  
  btn_Quit.Picture = LoadResPicture(RES_QUIT, 1)
  Set mo_FSO = New FileSystemObject
  
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, gl_CodePage, gl_CodePage, Me)
  
  If me_OfferStatus = eOfferStatus.osSAPSalesOrderChange Then
    opt_ProdType(0).Enabled = False
    opt_ProdType(2).Enabled = False
    opt_ProdType(3).Enabled = False
    opt_ProdType(4).Enabled = False
    opt_ProdType(5).Enabled = False
    opt_ProdType(6).Enabled = False
    opt_ProdType(7).Enabled = False
  End If
  Result = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Db = Nothing
  Set mo_FSO = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub

Private Sub opt_ProdType_Click(Index As Integer)
On Error GoTo ErrHandler
    
  Result = True
  Hide
  Exit Sub
ErrHandler:
  Call ErrorMessage("opt_ProdType_Click")
End Sub

Private Sub btn_Quit_Click()
On Error GoTo ErrHandler
  
  Result = False
  Hide
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Quit_Click")
End Sub

Public Property Get ProductType() As Long
On Error GoTo ErrHandler
  
  If opt_ProdType(0).Value Then
    ProductType = eDPCPriceBookType.eStockCapture
  ElseIf opt_ProdType(1).Value Then
    ProductType = eDPCPriceBookType.eStockMetal
  ElseIf opt_ProdType(2).Value Then
    ProductType = eDPCPriceBookType.eEngMetal
  ElseIf opt_ProdType(3).Value Then
    ProductType = eDPCPriceBookType.eWood
  ElseIf opt_ProdType(4).Value Then
    ProductType = eDPCPriceBookType.eSubconstruction
  ElseIf opt_ProdType(5).Value Then
    ProductType = eDPCPriceBookType.eVendor
  ElseIf opt_ProdType(6).Value Then
    ProductType = eDPCPriceBookType.eManualLine
  ElseIf opt_ProdType(7).Value Then
    ProductType = eDPCPriceBookType.eServiceItem
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("ProductType.Get")
End Property

Public Property Get ProductTypeDesc() As String
On Error GoTo ErrHandler
  
  If opt_ProdType(0).Value Then
    ProductTypeDesc = opt_ProdType(0).Caption
  ElseIf opt_ProdType(1).Value Then
    ProductTypeDesc = opt_ProdType(1).Caption
  ElseIf opt_ProdType(2).Value Then
    ProductTypeDesc = opt_ProdType(2).Caption
  ElseIf opt_ProdType(3).Value Then
    ProductTypeDesc = opt_ProdType(3).Caption
  ElseIf opt_ProdType(4).Value Then
    ProductTypeDesc = opt_ProdType(4).Caption
  ElseIf opt_ProdType(5).Value Then
    ProductTypeDesc = opt_ProdType(5).Caption
  ElseIf opt_ProdType(6).Value Then
    ProductTypeDesc = opt_ProdType(6).Caption
  ElseIf opt_ProdType(7).Value Then
    ProductTypeDesc = opt_ProdType(7).Caption
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("ProductTypeDesc.Get")
End Property

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub


